/*
 * File:    startup.c
 * Purpose: Generic Kinetis startup code
 *
 * Notes:   
 */
#if defined(CW)
__startup
#endif

#include "PortConfig.h"
#include "interrupt.h"

#pragma section = ".data"
#pragma section = ".data_init"
#pragma section = ".bss"
#pragma section = "CodeRelocate"
#pragma section = "CodeRelocateRam" 

/********************************************************************/
void
common_startup(void)
{ 
    /* Declare a counter we'll use in all of the copy loops */
    uint32_t n;
 
 
    /* Addresses for VECTOR_TABLE and VECTOR_RAM come from the linker file */  
    extern uint32_t __VECTOR_TABLE[];
    extern uint32_t __VECTOR_RAM[];

    /* Copy the vector table to RAM */
    if (__VECTOR_RAM != __VECTOR_TABLE)
    {
        for (n = 0; n < 0x410; n++)
            __VECTOR_RAM[n] = __VECTOR_TABLE[n];
    }
    /* Point the VTOR to the new copy of the vector table */
    write_vtor((uint32_t)__VECTOR_RAM);    
    
    /* Get the addresses for the .data section (initialized data section) */
    uint8_t* data_ram = __section_begin(".data");
    uint8_t* data_rom = __section_begin(".data_init");
    uint8_t* data_rom_end = __section_end(".data_init");
    
    /* Copy initialized data from ROM to RAM */
    n = data_rom_end - data_rom;
    while (n--)
      *data_ram++ = *data_rom++;
 
 
    /* Get the addresses for the .bss section (zero-initialized data) */
    uint8_t* bss_start = __section_begin(".bss");
    uint8_t* bss_end = __section_end(".bss");
    
    /* Clear the zero-initialized data section */
    n = bss_end - bss_start;
    while(n--)
      *bss_start++ = 0;    
    
    /* Get addresses for any code sections that need to be copied from ROM to RAM.
     * The IAR tools have a predefined keyword that can be used to mark individual
     * functions for execution from RAM. Add "__ramfunc" before the return type in
     * the function prototype for any routines you need to execute from RAM instead 
     * of ROM. ex: __ramfunc void foo(void);
     */
    uint8_t* code_relocate_ram = __section_begin("CodeRelocateRam");
    uint8_t* code_relocate = __section_begin("CodeRelocate");
    uint8_t* code_relocate_end = __section_end("CodeRelocate");
    
    /* Copy functions from ROM to RAM */
    n = code_relocate_end - code_relocate;
    while (n--)
      *code_relocate_ram++ = *code_relocate++;
}
/********************************************************************/
